<?php

namespace Drupal\api_toolkit;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Symfony\Component\DependencyInjection\Reference;

/**
 * The service provider.
 */
class ApiToolkitServiceProvider implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    $argumentResolver = $container->getDefinition('http_kernel.controller.argument_resolver');
    $argumentValueResolvers = $argumentResolver->getArgument(1);
    array_unshift($argumentValueResolvers, new Reference('api_toolkit.argument_resolver.api_request'));
    $argumentResolver->setArgument(1, $argumentValueResolvers);
  }

}
