<?php

namespace Drupal\api_toolkit\ArgumentResolver;

use Drupal\api_toolkit\Request\ApiRequestInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ArgumentValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

/**
 * Converts normal Synfomy requests to ApiRequestInterface instances.
 */
class ApiRequestResolver implements ArgumentValueResolverInterface {

  /**
   * The Symfony normalizer.
   *
   * @var \Symfony\Component\Serializer\Normalizer\NormalizerInterface
   */
  protected $normalizer;

  /**
   * Constructs a new ApiRequestResolver object.
   *
   * @param \Symfony\Component\Serializer\Normalizer\NormalizerInterface $normalizer
   *   The Symfony normalizer.
   */
  public function __construct(
    NormalizerInterface $normalizer
  ) {
    $this->normalizer = $normalizer;
  }

  /**
   * {@inheritdoc}
   */
  public function supports(Request $request, ArgumentMetadata $argument) {
    return is_a($argument->getType(), ApiRequestInterface::class, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function resolve(Request $request, ArgumentMetadata $argument) {
    /** @var class-string<ApiRequestInterface> $requestClass */
    $requestClass = $argument->getType();

    // Transform to API request class.
    yield $this->normalizer->denormalize($request, $requestClass);
  }

}
