<?php

namespace Drupal\api_toolkit\Validation;

use Drupal\Core\TypedData\Validation\ExecutionContextFactory;
use Drupal\Core\Validation\DrupalTranslator;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Factory for creating execution contexts.
 */
class ContextFactory {

  /**
   * The Symfony validator.
   *
   * @var \Symfony\Component\Validator\Validator\ValidatorInterface
   */
  protected $validator;

  /**
   * Constructs a new ContextFactory.
   *
   * @param \Symfony\Component\Validator\Validator\ValidatorInterface $validator
   *   A Symfony validator.
   */
  public function __construct(ValidatorInterface $validator) {
    $this->validator = $validator;
  }

  /**
   * Creates an execution context.
   */
  public function create($root = NULL): ExecutionContextInterface {
    return $this->getExecutionContextFactory()
      ->createContext($this->validator, $root);
  }

  /**
   * Creates an execution context factory.
   */
  protected function getExecutionContextFactory(): ExecutionContextFactory {
    return new ExecutionContextFactory(new DrupalTranslator());
  }

}
