<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether an entity with a certain UUID exists.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "enum",
 *     label = @Translation("Checks if an enum with a certain case exists", context = "Validation"),
 * )
 */
class Enum extends Constraint {

  /**
   * The error message in case of an invalid enum.
   *
   * @var string
   */
  public string $invalidEnum = 'A backed enum with class name %value does not exist.';

  /**
   * The error message in case of an invalid enum case.
   *
   * @var string
   */
  public string $invalidCase = "The value '%value' is not a valid option. Choose one of the following: %cases.";

  /**
   * The enum.
   *
   * @var string|null
   */
  public ?string $enum = NULL;

  /**
   * {@inheritdoc}
   */
  public function getDefaultOption(): ?string {
    return 'enum';
  }

  /**
   * {@inheritdoc}
   */
  public function getRequiredOptions(): array {
    return ['enum'];
  }

}
