<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether a certain value is a valid language code.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "langcode",
 *     label = @Translation("Language code", context = "Validation"),
 * )
 */
class Langcode extends Constraint {

  /**
   * The error message.
   *
   * @var string
   */
  public $message = '%value is not a valid language code.';

}
