<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether an entity with a certain UUID exists.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "entity_exists",
 *     label = @Translation("Checks if an entity with a certain id exists", context = "Validation"),
 * )
 */
class EntityExists extends Constraint {

  public const INVALID_ID_ERROR = 'b678116c-6125-11ee-8c99-0242ac120002';

  protected static $errorNames = [
    self::INVALID_ID_ERROR => 'INVALID_ID_ERROR',
  ];

  /**
   * The error message in case the identifier does not resolve to an entity.
   *
   * @var string
   */
  public string $message = 'No @entityType with %fieldLabel %value exists.';

  /**
   * The entity type ID.
   *
   * @var string|null
   */
  public ?string $entityTypeId = NULL;

  /**
   * The entity bundle.
   *
   * @var string|null
   */
  public ?string $bundle = NULL;

  /**
   * The field name to check.
   *
   * @var string
   */
  public string $fieldName = 'uuid';

  /**
   * {@inheritdoc}
   */
  public function getRequiredOptions(): array {
    return ['entityTypeId'];
  }

}
