<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether a certain value is a valid language code.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "langcode",
 *     label = @Translation("Language code", context = "Validation"),
 * )
 */
class Langcode extends Constraint {

  public const INVALID_LANGCODE_ERROR = 'f598446e-f8eb-4696-a35f-6a545087ae3b';

  protected static $errorNames = [
    self::INVALID_LANGCODE_ERROR => 'INVALID_LANGCODE_ERROR',
  ];

  /**
   * The error message.
   *
   * @var string
   */
  public $message = '%value is not a valid language code.';

}
