<?php

namespace Drupal\apidae_tourisme_criteres\EventSubscriber;

use Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\taxonomy\Entity\Term;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * ApidaeNodePresaveEvent implementation.
 *
 * @see \Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent
 *
 * @package Drupal\apidae_tourisme_examples\EventSubscriber
 */
class ApidaeCritereNodePresaveSubscriber implements EventSubscriberInterface {

  /**
   * Entity manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  private $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

    /**
   * Return the subscribed event(s).
   *
   * @return array|string[]
   *   Subscribed event(s).
   */
  public static function getSubscribedEvents() {
    return [ApidaeNodePresaveEvent::EVENT_NAME => 'nodeUpdate'];
  }

  /**
   * The main function to alter the node.
   *
   * @param \Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent $event
   *   The Event object.
   */
  public function nodeUpdate(ApidaeNodePresaveEvent $event) {
    $node = $event->getNode();
    $objet = $event->getApidaeObject();
    $criteres = $this->getCriteres($objet);
    $criteresIds = [];
    foreach($criteres as $critere) {
      if (!$term = $this->entityTypeManager->getStorage('taxonomy_term')->loadByProperties(['vid' => 'apidae_criteres_internes', 'field_id_apidae' => $critere['id']])) {
        $term =  Term::create([
          'vid' => 'apidae_criteres_internes',
          'name' => $critere['libelle'],
          'field_id_apidae' => ['value' => $critere['id']],
        ]);
        $term->save();
      }
      else {
        $term = array_pop($term);
        /** @var Term $term */
        if($term->label() !== $critere['libelle']) {
          $term->setName($critere['libelle']);
          $term->save();
        }
      }
      $criteresIds[] = $term->id();
    }
    $node->set('field_criteres_internes', $criteresIds);
  }

  /**
   * Parse Apidae Object tree and return data.
   *
   * @param array $object
   *   The apidae object.
   * @param string $locale
   *   The langcode wanted.
   *
   * @return mixed|null
   *   The data, null if not existing.
   */
  private function getCriteres(array $object) {
    if(isset($object['criteresInternes']) && is_array($object['criteresInternes'])) {
      return $object['criteresInternes'];
    }
    return [];
  }

}
