<?php

namespace Drupal\apidae_tourisme_criteres\EventSubscriber;

use Drupal\apidae_tourisme\Event\ApidaeQueryBuilderEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Example of ApidaeQueryBuilderEvent implementation.
 *
 * @see ApidaeQueryBuilderEvent
 *
 * @package Drupal\apidae_tourisme_examples\EventSubscriber
 */
class ApidaeCritereQueryBuilderSubscriber implements EventSubscriberInterface {

  /**
   * Return the subscribed event(s).
   *
   * @return array|string[]
   *   Subscribed event(s).
   */
  public static function getSubscribedEvents(): array {
    return [ApidaeQueryBuilderEvent::EVENT_NAME => 'alterQuery'];
  }

  /**
   * The main function to alter the query.
   *
   * @param \Drupal\apidae_tourisme\Event\ApidaeQueryBuilderEvent $event
   *   The Event object.
   */
  public function alterQuery(ApidaeQueryBuilderEvent $event) {
    $query = $event->getQuery();

    $query['responseFields'][] = 'criteresInternes';

    $event->setQuery($query);
  }

}
