<?php

namespace Drupal\apidae_tourisme_selections\EventSubscriber;

use Drupal\apidae_tourisme\ApidaeSync;
use Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * ApidaeNodePresaveEvent implementation.
 *
 * @see \Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent
 *
 * @package Drupal\apidae_toursime_selections\EventSubscriber
 */
class ApidaeSelectionsNodePresaveSubscriber implements EventSubscriberInterface {

  /**
   * Entity manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  private $entityTypeManager;

  /**
   * @var \Drupal\apidae_tourisme\ApidaeSync
   */
  private $apidaeSync;

  public function __construct(EntityTypeManagerInterface $entityTypeManager, ApidaeSync $apidaeSync) {
    $this->entityTypeManager = $entityTypeManager;
    $this->apidaeSync = $apidaeSync;
  }

  /**
   * Return the subscribed event(s).
   *
   * @return array|string[]
   *   Subscribed event(s).
   */
  public static function getSubscribedEvents(): array {
    return [ApidaeNodePresaveEvent::EVENT_NAME => 'nodeUpdate'];
  }

  /**
   * The main function to alter the node.
   *
   * @param \Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent $event
   *   The Event object.
   */
  public function nodeUpdate(ApidaeNodePresaveEvent $event) {
    $node = $event->getNode();
    $objet = $event->getApidaeObject();
    $selections = $this->getSelections($objet);
    $node->set('field_selections', $selections);
  }

  /**
   * Parse Apidae Object tree and return data.
   *
   * @param array $object
   *   The apidae object.
   *
   * @return array
   *   An array of int representing the selections.
   */
  private function getSelections(array $object) {
    $selections = $this->apidaeSync->selectionsParObjetQuery([$object['id']]);
    $selectionsArray = [];
    if(isset($selections[0]['selections']) && is_array($selections[0]['selections'])) {
      foreach ($selections[0]['selections'] as $sel) {
        $selectionsArray[] = (int) $sel['id'];
      }
    }
    return $selectionsArray;
  }

}
