<?php

namespace Drupal\apidae_tourisme_tarifs\EventSubscriber;

use Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;


class ApidaeTarifsNodePresaveSubscriber implements EventSubscriberInterface {

  /**
   * Entity manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  private $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

    /**
   * Return the subscribed event(s).
   *
   * @return array|string[]
   *   Subscribed event(s).
   */
  public static function getSubscribedEvents(): array {
    return [ApidaeNodePresaveEvent::EVENT_NAME => 'nodeUpdate'];
  }

  /**
   * The main function to alter the node.
   *
   * @param \Drupal\apidae_tourisme\Event\ApidaeNodePresaveEvent $event
   *   The Event object.
   */
  public function nodeUpdate(ApidaeNodePresaveEvent $event) {
    $langcode = $event->getLangcode();
    $locales = $event->getLocales();

    $node = $event->getNode();
    $objet = $event->getApidaeObject();

    $node->set('field_tarifs', [
      'value' => $this->getTarif($objet, $langcode),
    ]);
    $node->set('field_gratuit',  $this->isGratuit($objet));

    foreach ($locales as $locale) {
      if ($node->hasTranslation($locale) && $translation = $node->getTranslation($locale)) {
        $translation->set('field_tarifs', [
          'value' => $this->getTarif($objet, $locale),
        ]);
      }
    }
  }

  /**
   * Parse Apidae Object tree and return data.
   *
   * @param array $object
   *   The apidae object.
   * @param string $locale
   *   The langcode wanted.
   *
   * @return mixed|null
   *   The data, null if not existing.
   */
  private function getTarif(array $object, $locale) {
    $key = 'libelle' . ucfirst($locale);
    return $object['descriptionTarif']['tarifsEnClair'][$key] ?? NULL;
  }

  /**
   * Parse Apidae Object tree and return data.
   *
   * @param array $object
   *   The apidae object.
   *
   * @return mixed|null
   *   The data, null if not existing.
   */
  private function isGratuit(array $object) {
    return (bool) $object['descriptionTarif']['gratuit'];
  }

}
