<?php

namespace Drupal\apidae_tourisme_tarifs\EventSubscriber;

use Drupal\apidae_tourisme\Event\ApidaeQueryBuilderEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ApidaeTarifsQueryBuilderSubscriber implements EventSubscriberInterface {

  /**
   * Return the subscribed event(s).
   *
   * @return array|string[]
   *   Subscribed event(s).
   */
  public static function getSubscribedEvents(): array {
    return [ApidaeQueryBuilderEvent::EVENT_NAME => 'alterQuery'];
  }

  /**
   * The main function to alter the query.
   *
   * @param \Drupal\apidae_tourisme\Event\ApidaeQueryBuilderEvent $event
   *   The Event object.
   */
  public function alterQuery(ApidaeQueryBuilderEvent $event) {
    $query = $event->getQuery();
    if(!in_array('descriptionTarif.tarifsEnClair', $query['responseFields'])) {
      $query['responseFields'][] = 'descriptionTarif.tarifsEnClair';
    }
    if(!in_array('descriptionTarif.gratuit', $query['responseFields'])) {
      $query['responseFields'][] = 'descriptionTarif.gratuit';
    }

    $event->setQuery($query);
  }

}
