/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  Drupal.color = {
    logoChanged: false,
    callback: function callback(context, settings, $form) {
      if (!this.logoChanged) {
        $('.color-preview .color-preview-logo img').attr('src', drupalSettings.color.logo);
        this.logoChanged = true;
      }

      if (drupalSettings.color.logo === null) {
        $('div').remove('.color-preview-logo');
      }
      var imagesFolder = '/themes/iris/images/';
      var $colorPreview = $form.find('.color-preview');
      var $colorPalette = $form.find('.js-color-palette');

      $colorPreview.css('backgroundColor', $colorPalette.find('input[name="palette[bg]"]').val());

      $colorPreview.find('.color-preview-main h2, .color-preview .preview-content').css('color', $colorPalette.find('input[name="palette[text]"]').val());
      $colorPreview.find('.color-preview-content a').css('color', $colorPalette.find('input[name="palette[link]"]').val());

      var $colorPreviewBlock = $colorPreview.find('.color-preview-block .box-content');
      $colorPreviewBlock.css('background-color', $colorPalette.find('input[name="palette[sidebar]"]').val());
      $colorPreviewBlock.css('border-color', $colorPalette.find('input[name="palette[sidebarborders]"]').val());

      $colorPreview.find('.color-preview-footer-wrapper').css('background-color', $colorPalette.find('input[name="palette[footer]"]').val());

      var headerColor = $colorPalette.find('input[name="palette[header]"]').val();
      var headerContent = $colorPalette.find('input[name="palette[header_content]"]').val();

      $colorPreview.find('.color-preview-header').attr('style', 'background: linear-gradient(to bottom, ' + this.convertHexTorgba(headerColor, 0.85) + ' 0%, ' + headerColor + ' 100%), url(' + imagesFolder +'banner_image.jpg) no-repeat;');
      $colorPreview.find('.color-preview-header .banner-content').attr('style', `color: ${headerContent}`);

      $colorPreview.find('.color-preview-site-name').css('color', $colorPalette.find('input[name="palette[titleslogan]"]').val());
    },
    convertHexTorgba: function (hex, a) {
      var c;
      if(/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)){
        c= hex.substring(1).split('');
        if(c.length== 3){
          c= [c[0], c[0], c[1], c[1], c[2], c[2]];
        }
        c= '0x'+c.join('');
        return 'rgba('+[(c>>16)&255, (c>>8)&255, c&255].join(',')+','+ a +')';
      }
      throw new Error('Bad Hex');
    }
  };
})(jQuery, Drupal, drupalSettings);
