(function ($, Drupal) {
  Drupal.behaviors.adminToolbarSearch = {
    attach: function (context) {
      if (context != document) {
        return;
      }
      var getUrl = window.location;
      var baseUrl = getUrl.protocol + "//" + getUrl.host + "/";
      var $self = this;
      this.links = [];
      $('a[data-drupal-link-system-path]').each(function() {

        if (this.href != baseUrl) {
          var label = $self.getItemLabel(this);
          $self.links.push({
            'value': $(this).attr('href'),
            'label': label + ' ' + $(this).attr('href'),
            'labelRaw': label
          });
        }
      });

      $( "#admin-toolbar-search-input").autocomplete({
        minLength: 2,
        source: function(request, response) {
          var data = $self.handleAutocomplete(request.term);
          response(data);
        },
        open: function(){
          var zIndex = $('#toolbar-item-administration-search-tray').css("z-index")+1;
          $(this).autocomplete('widget').css('z-index', zIndex);
          return false;
        },
        select: function( event, ui ) {
          if (ui.item.value) {
            location.href = ui.item.value;
            return false;
          }
        }
      }).data("ui-autocomplete")._renderItem = (function(ul, item) {
        return $("<li>")
          .append('<div>' + item.labelRaw + ' <span class="admin-toolbar-search-url">' + item.value + '</span></div>')
          .appendTo(ul);
      });

      // Focus on search field when tab is clicked, or enter is pressed.
      $(context).find('#toolbar-item-administration-search').once('admin_toolbar_search').each(function () {
        if ($('#toolbar-item-administration-search-tray:visible').length) {
          $('#admin-toolbar-search-input').focus();
        }
        $(this).on('click', function() {
          $self.focusOnSearchElement();
        });
      });
    },
    focusOnSearchElement: function() {
      var waitforVisible = function() {
        if ($('#toolbar-item-administration-search-tray:visible').length) {
          $('#admin-toolbar-search-input').focus();
        } else {
          setTimeout(function() {
            waitforVisible();
          }, 1);
        }
      };
      waitforVisible();
    },
    getItemLabel: function(item) {
      var breadcrumbs = [];
      $(item).parents().each(function() {
        if ($(this).hasClass('menu-item')) {
          var $link = $(this).find('a:first');
          if ($link.length && !$link.hasClass('admin-toolbar-search-ignore')) {
            breadcrumbs.unshift($link.text());
          }
        }
      });

      label = breadcrumbs.join(' > ');

      return label;
    },
    handleAutocomplete: function(term) {
      var $self = this;
      var keywords = term.split(" "); // split search terms into list.

      var suggestions = [];
      $self.links.forEach(function(element) {
        var label = element.label.toLowerCase();

        // Add exact matches.
        if (label.indexOf(term.toLowerCase()) >= 0) {
          suggestions.push(element);
        }
        else {
          // Add suggestions where it matches all search terms.
          var matchCount = 0;
          keywords.forEach(function(keyword) {
            if (label.indexOf(keyword.toLowerCase()) >= 0) {
              matchCount++;
            }
          });
          if (matchCount == keywords.length) {
            suggestions.push(element);
          }
        }
      });
      return suggestions;
    }
  };
})(jQuery, Drupal);
