<?php

namespace Drupal\apitools_examples\Plugin\ApiTools;

use Brandfolder\Brandfolder as BrandfolderSdk;
use Drupal\apitools\Api\Client\ClientBase;
use Drupal\Component\Serialization\Json;

/**
 * Creates a new ApiTools api client.
 *
 * @ApiToolsClient(
 *   id = "brandfolder",
 *   admin_label = @Translation("Brandfolder API Client"),
 *   api = "brandfolder",
 *   client_default_controller = "\Drupal\apitools_examples\Plugin\ApiTools\Brandfolder\ClientController"
 * )
 */
class Brandfolder extends ClientBase {

  protected $sdk;

  /**
   * {@inheritdoc}
   */
  protected function auth() {
    $this->sdk();
    return $this;
  }

  public function sdk() {
    if (!isset($this->sdk)) {
      $apikey = '[hardcoded api key]';
      $this->sdk = new BrandfolderSdk($apikey);
      $this->sdk->default_brandfolder_id = '[hardcoded brandfolder id]';
    }
    return $this->sdk;
  }

  /**
   * {@inheritdoc}
   */
  public function request($method, $path, $options = []) {
    $response = $this->sdk->request($method, "/$path", $options);
    return $this->postRequest($response);
  }

  /**
   * {@inheritdoc}
   */
  protected function postRequest($response) {
    $response = parent::postRequest($response);
    if ($response->getBody()) {
      return Json::decode($response->getBody()->getContents());
    }
    return $response;
  }
}