<?php

namespace Drupal\apitools\Menu;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Menu\MenuLinkManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class MenuLinkDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The menu link manager.
   *
   * @var \Drupal\Core\Menu\MenuLinkManagerInterface
   */
  protected $menuLinkManager;

  /**
   * Constructs a MenuLinkContentDeriver instance.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\Core\Menu\MenuLinkManagerInterface $menu_link_manager
   *   The menu link manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, MenuLinkManagerInterface $menu_link_manager) {
    $this->entityTypeManager = $entity_type_manager;
    $this->menuLinkManager = $menu_link_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('entity_type.manager'),
      $container->get('plugin.manager.menu.link')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $plugin_definitions = [];

    /** @var \Drupal\apitools\ClientManager $client_manager */
    $client_manager = \Drupal::service('plugin.manager.apitools_client');
    foreach ($client_manager->getDefinitions() as $definition) {
      if (empty($definition['config'])) {
        continue;
      }
      $client_plugin_id = $definition['id'];

      $plugin_definitions[$client_plugin_id] = [
        'title' => $definition['admin_label'] . ' Settings',
        'parent' => 'system.admin_config_services',
        'route_name' => 'apitools.client_config_form.' . $client_plugin_id,
      ];

      if (!empty($definition['admin_description'])) {
        $plugin_definitions[$client_plugin_id]['description'] = $definition['admin_description'];
      }
    }
    return $plugin_definitions;
  }

}
