<?php

namespace Drupal\apitools\Testing;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Serialization\Yaml;
use weitzman\DrupalTestTraits\ExistingSiteBase as WeitzmanExistingSiteBase;

abstract class ExistingSiteBase extends WeitzmanExistingSiteBase {

  use ExistingSiteTrait;

  /**
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * @var \Drupal\Core\Entity\EntityRepositoryInterface
   */
  protected $entityRepository;

  /**
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * @var \Drupal\Core\File\FileSystemInterface
   */

  protected $fileSystem;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->entityTypeManager = $this->container->get('entity_type.manager');
    $this->entityRepository = $this->container->get('entity_type.manager');
    $this->moduleHandler = $this->container->get('module_handler');
    $this->fileSystem = $this->container->get('file_system');
  }

  protected function entityReload(EntityInterface $entity) {
    $id = $entity->id();
    $entity_type = $entity->getEntityTypeId();
    $entity_storage = $this->entityTypeManager->getStorage($entity_type);
    $entity_storage->resetCache([$entity->id()]);
    return $entity_storage->load($id);
  }

  protected function uuidToId($entity_type, $uuid) {
    $entity = $this->entityRepository->loadEntityByUuid($entity_type, $uuid);
    return $entity ? $entity->id() : FALSE;
  }

  /**
   * @deprecated
   */
  protected function getTestData($name, $path = NULL, $ext = NULL) {
    $path = $path ? $path : $this->getFixturesPath();
    $ext = $ext ? $ext : 'yml';
    $file = file_get_contents($path . "{$name}.{$ext}");
    $data = Yaml::decode($file);
    $this->assertNotNull($data, "Encoded yml file $name is not null");
    return $data;
  }

  protected function convertToArray($object) {
    return Json::decode(Json::encode($object));
  }

  protected function exportToYaml($php_array) {
    // Either convert object to array, or, ensure all recursive values are arrays.
    $php_array = $this->convertToArray($php_array);
    return Yaml::encode($php_array);
  }
}
