<?php

namespace Drupal\apitools\Testing;

use Drupal\Tests\apitools\Traits\ArraySubset;
use PHPUnit\Framework\ExpectationFailedException;
use PHPUnit\Framework\InvalidArgumentException;

trait ExistingSiteTrait {

  protected function getModuleHandler() {
    if (!isset($this->moduleHandler)) {
      return $this->container->get('module_handler');
    }
    return $this->moduleHandler;
  }

  protected function getFileSystem() {
    if (!isset($this->fileSystem)) {
      return $this->container->get('file_system');
    }
    return $this->fileSystem;
  }
  
  protected function getFixturesPath($module_name) {
    $module_path = $this->getModuleHandler()->getModule($module_name)->getPath();
    $path = $this->getFileSystem()->realpath($module_path);
    return "$path/tests/fixtures";
  }

  /**
   * Asserts that an array has a specified subset.
   *
   * @param array|\ArrayAccess $subset
   * @param array|\ArrayAccess $array
   *
   * @throws ExpectationFailedException
   * @throws \SebastianBergmann\RecursionContext\InvalidArgumentException
   */
  public static function assertArraySubset($subset, $array, bool $checkForObjectIdentity = false, string $message = ''): void {
    if (!(\is_array($subset) || $subset instanceof \ArrayAccess)) {
      throw InvalidArgumentException::create(
        1,
        'array or ArrayAccess'
      );
    }

    if (!(\is_array($array) || $array instanceof \ArrayAccess)) {
      throw InvalidArgumentException::create(
        2,
        'array or ArrayAccess'
      );
    }

    $constraint = new ArraySubset($subset, $checkForObjectIdentity);

    static::assertThat($array, $constraint, $message);
  }

  /**
   * Search current page for text by CSS selector provided.
   *
   * @deprecated
   *   Use \Behat\Mink\WebAssert::assertSession()->elementTextNotContains()
   *
   * @param $selector
   *   CSS Selector passed to \Behat\Mink\Element\ElementInterface::findAll()
   * @param $text
   *   The string of text to search for
   */
  protected function assertElementNotContainsText($selector, $text) {
    $this->assertSession()->elementTextNotContains('css', $selector, $text);
    $results = $this->getSession()->getPage()->findAll('css', $selector);
    $elements = [];
    foreach ($results as $element) {
      $elements[] = $element->getText();
    }

    $this->assertNotContains($text, $elements);
  }

  /**
   * Search current page for text by CSS selector provided.
   *
   * @deprecated
   *   Use \Behat\Mink\WebAssert::assertSession()->elementTextContains()
   *
   * @param $selector
   *   CSS Selector passed to \Behat\Mink\Element\ElementInterface::findAll()
   * @param $text
   *   The string of text to search for
   */
  protected function assertPageContainsText($selector, $text) {
    $results = $this->getSession()->getPage()->findAll('css', $selector);
    $elements = [];
    foreach ($results as $element) {
      $elements[] = $element->getText();
    }

    $this->assertContains($text, $elements);
  }

  /**
   * Asserts that an array has a specified key.
   *
   * @param mixed             $key
   * @param array|\ArrayAccess $array
   * @param string            $message
   */
  protected function assertArrayHasKeys($keys, $array, $message = '') {
    foreach ($keys as $key) {
      $this->assertArrayHasKey($key, $array, $message);
    }
  }

  /**
   * Asserts that an array has a specified key.
   *
   * @param mixed             $key
   * @param array|\ArrayAccess $array
   * @param string            $message
   */
  protected function assertArrayNotHasKeys($keys, $array, $message = '') {
    foreach ($keys as $key) {
      $this->assertArrayNotHasKey($key, $array, $message);
    }
  }
}
