<?php

namespace Drupal\apple_pay_verification\Controller;

use Drupal\Core\Cache\CacheableResponse;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\file\FileInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns responses for Apple Pay Verification routes.
 */
class ApplePayVerificationController extends ControllerBase {

  /**
   * @var ConfigFactoryInterface
   *
   * The configuration factory.
   */
  protected $configFactory;

  /**
   * @var EntityTypeManagerInterface
   * The entity type manager service.
   */
  protected $entityTypeManager;

  /**
   * @param ConfigFactoryInterface $configFactory
   *   The configuration factory.
   */
  public function __construct(ConfigFactoryInterface $configFactory, EntityTypeManagerInterface $entityTypeManager) {
    $this->configFactory = $configFactory;
    $this->entityTypeManager = $entityTypeManager;
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('entity_type.manager'),
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke() {
    $fileId = $this->configFactory->get('apple_pay_verification.settings')->get('verification_file');
    $fileId = reset($fileId);
    /** @var FileInterface $file */
    $file = $this->entityTypeManager->getStorage('file')->load($fileId);

    $response = new CacheableResponse(file_get_contents($file->getFileUri()));
    return $response;
  }

}
