<?php
/**
 * @file
 * fe_appstore.rules_defaults.inc
 */

/**
 * Implementation of hook_default_rules_configuration().
 */
function appstore_feature_default_rules_configuration() {
  $items = array();
  $items['rules_add_product_display_for_each_pro'] = entity_import('rules_config', '{ "rules_add_product_display_for_each_pro" : {
      "LABEL" : "Add product display for each product",
      "PLUGIN" : "reaction rule",
      "REQUIRES" : [ "rules", "entity" ],
      "ON" : [ "commerce_product_insert" ],
      "DO" : [
        { "entity_create" : {
            "USING" : {
              "type" : "node",
              "param_type" : "digital_product_display",
              "param_title" : [ "commerce-product:title" ],
              "param_author" : [ "commerce-product:creator" ]
            },
            "PROVIDE" : { "entity_created" : { "entity_created" : "Created entity" } }
          }
        },
        { "data_set" : {
            "data" : [ "entity-created:field-digital-product-reference" ],
            "value" : [ "commerce-product" ]
          }
        }
      ]
    }
  }');
  $items['rules_go_to_checkout'] = entity_import('rules_config', '{ "rules_go_to_checkout" : {
      "LABEL" : "go to checkout",
      "PLUGIN" : "reaction rule",
      "REQUIRES" : [ "rules", "commerce_cart" ],
      "ON" : [ "commerce_cart_product_add" ],
      "DO" : [ { "redirect" : { "url" : "checkout" } } ]
    }
  }');
  $items['rules_order_with_full_payment'] = entity_import('rules_config', '{ "rules_order_with_full_payment" : {
      "LABEL" : "Order With Full Payment",
      "PLUGIN" : "reaction rule",
      "REQUIRES" : [ "commerce_payment", "commerce_order", "commerce_checkout" ],
      "ON" : [ "commerce_checkout_complete" ],
      "IF" : [ { "commerce_payment_order_balance_comparison" : { "value" : "0" } } ],
      "DO" : [ { "commerce_order_update_status" : { "order_status" : "completed" } } ]
    }
  }');
  return $items;
}
