<?php

// $Id: template.php,v 1.1.2.2 2009/05/18 16:14:39 kevinhankens Exp $

/**
 * @file
 */

/**
* Override or insert PHPTemplate variables into the templates.
*/
function aquanaut_preprocess_page(&$vars) {
  // Hook into color.module
  if (module_exists('color')) {
    _color_page_alter($vars);
  }

  // Adjust ie.css path if color module is working its magic
  $color_paths = variable_get('color_aquanaut_stylesheets', array());
  if (!empty($color_paths)) {
    $vars['color_ie_path'] = base_path() . $color_paths[1];
  }

  $vars['mission'] = variable_get('site_mission', '');
}

/**
 * Implementation of theme_menu_local_tasks().
 */
function aquanaut_menu_local_tasks() {
  $output = '';

  if ($primary = menu_primary_local_tasks()) {
    $output .= "<div class=\"localtasks\"><ul class=\"tabs primary clearfix\">\n". $primary ."</ul></div>\n";
  }
  if ($secondary = menu_secondary_local_tasks()) {
    $output .= "<div class=\"localtasks\"><ul class=\"tabs secondary clearfix\">\n". $secondary ."</ul></div>\n";
  }

  return $output;
}
