<?php

/**
 * Managed deployment aggregator.
 */
class DeployAggregatorManaged extends DeployAggregatorBase {

  public $config = array();

  /**
   * Holds a reference to the plan object that initiated it.
   *
   * @var DeployPlan
   */
  public $plan;

  public function __construct(DeployPlan $plan = NULL, Array $config = array()) {
    $this->config += array(
      'debug' => FALSE,
      'delete_post_deploy' => FALSE,
    );
    $this->config = array_merge($this->config, $config);
    $this->plan = $plan;
  }

  /**
   * Get aggregated entities.
   */
  public function getEntities() {
    return deploy_manager_get_entities($this->plan->name);
  }

  public function configForm(&$form_state) {
    $form = array();
    $form['delete_post_deploy'] = array(
      '#type' => 'checkbox',
      '#title' => t('Delete successfully deployed entities from the plan'),
      '#description' => t('If checked, each successfully deployed entity will be automatically deleted from the plan.'),
      '#default_value' => $this->config['delete_post_deploy'],
    );
    return $form;
  }
}
