/**
 * DO NOT EDIT THIS FILE.
 * See the following change record for more information,
 * https://www.drupal.org/node/2815083
 * @preserve
 **/

(function ($, Drupal) {
  Drupal.behaviors.productPreviewDestroyLinks = {
    attach: function attach(context) {
      function clickPreviewModal(event) {
        if (event.button === 0 && !event.altKey && !event.ctrlKey && !event.metaKey && !event.shiftKey) {
          event.preventDefault();
          var $previewDialog = $('<div>' + Drupal.theme('productPreviewModal') + '</div>').appendTo('body');
          Drupal.dialog($previewDialog, {
            title: Drupal.t('Leave preview?'),
            buttons: [{
              text: Drupal.t('Cancel'),
              click: function click() {
                $(this).dialog('close');
              }
            }, {
              text: Drupal.t('Leave preview'),
              click: function click() {
                window.top.location.href = event.target.href;
              }
            }]
          }).showModal();
        }
      }

      var $preview = $(context).once('product-preview');
      if ($(context).find('.product-preview-container').length) {
        $preview.on('click.preview', 'a:not([href^="#"], .product-preview-container a)', clickPreviewModal);
      }
    },
    detach: function detach(context, settings, trigger) {
      if (trigger === 'unload') {
        var $preview = $(context).find('.content').removeOnce('product-preview');
        if ($preview.length) {
          $preview.off('click.preview');
        }
      }
    }
  };

  Drupal.behaviors.productPreviewSwitchViewMode = {
    attach: function attach(context) {
      var $autosubmit = $(context).find('[data-drupal-autosubmit]').once('autosubmit');
      if ($autosubmit.length) {
        $autosubmit.on('formUpdated.preview', function () {
          $(this.form).trigger('submit');
        });
      }
    }
  };

  Drupal.theme.productPreviewModal = function () {
    return '<p>' + Drupal.t('Leaving the preview will cause unsaved changes to be lost. Are you sure you want to leave the preview?') + '</p><small class="description">' + Drupal.t('CTRL+Left click will prevent this dialog from showing and proceed to the clicked link.') + '</small>';
  };
})(jQuery, Drupal);
