
(function(Archibald) {

Archibald.templates = Archibald.templates || (Archibald.templates = new Object());

// Add our own templates.
Archibald.templates.currMappingSuggestionsOpt = '\
  <% for (var i = 0, len = items.length; i < len; i++) { %>\
    <div class="\
      archibald-curricula-field__editor__opts__opt\
      archibald-curricula-field__editor__opts__opt--suggestions-opt-out\
      ">\
      <label><input type="checkbox" data-for="<%= items[i].name %>" checked> \
      <%= Drupal.t("Get suggestions for the %curriculum", {\
        "%curriculum": items[i].label\
      }) %>\
      </label>\
    </div>\
  <% } %>\
';

Archibald.templates.currMappingSuggestionsWrapper = '\
  <div class="archibald-curricula-field__editor__suggestions messages warning">\
    <a class="archibald-curricula-field__editor__suggestions__close">\
      <%= Drupal.t("dismiss") %>\
    </a>\
    <div class="archibald-curricula-field__editor__suggestions__content"></div>\
  </div>\
';

Archibald.templates.currMappingSuggestions = '\
  <strong><%= Drupal.t("Recommendation") %></strong>\
  <% for (var curriculum in items) { %>\
    <em><%= Drupal.checkPlain(items[curriculum].label) %></em>\
    <ul>\
      <% for (var i = 0, len = items[curriculum].suggestions.length; i < len; i++) { %>\
      <li>\
        <a\
          class="archibald-curricula-field__editor__suggestions__content__add"\
          data-item-id="<%= Drupal.checkPlain(items[curriculum].suggestions[i].id) %>"\
          data-for="<%= curriculum %>">\
        <%= Drupal.t("add") %>\
        </a><%= Drupal.checkPlain(items[curriculum].suggestions[i].label) %>\
      </li>\
      <% } %>\
    </ul>\
  <% } %>\
';

})(window.ArchibaldCurriculum || (window.ArchibaldCurriculum = new Object()));
