<?php

/**
 * @file
 * Contains archibald_stats_date_field.
 */

class archibald_stats_date_field extends views_handler_field_date {

  /**
   * @{inheritdoc}
   */
  function render($values) {
    // The date field doesn't actually exist. Instead, we have to construct it
    // from the year, month and day fields.
    $values->date = !isset($values->month) ?
      strtotime("{$values->year}-01-01") :
      (
        isset($values->day) ?
          strtotime("{$values->year}-{$values->month}-{$values->day}") :
          strtotime("{$values->year}-{$values->month}-01")
      );
    return parent::render($values);
  }
}
