<?php

/**
 * @file
 * Contains archibald_stats_text_filter.
 */

class archibald_stats_text_filter extends views_handler_filter_string {

  /**
   * @{inheritdoc}
   */
  function operators() {
    $operators = parent::operators();
    // Only allow certain operators.
    return array(
      '=' => $operators['='],
      'contains' => $operators['contains'],
      'starts' => $operators['starts'],
    );
  }

  /**
   * @{inheritdoc}
   */
  function op_equal($field) {
    $value = addslashes($this->value);
    $this->query->add_filter("op_equal.{$this->field}", create_function('$item', "return '{$value}' == \$item->{$this->field};"));
  }

  /**
   * @{inheritdoc}
   */
  function op_contains($field) {
    $value = $this->clean_value();
    $this->query->add_filter("op_contains.{$this->field}", create_function('$item', "return preg_match('/{$value}/', \$item->{$this->field});"));
  }

  /**
   * @{inheritdoc}
   */
  function op_starts($field) {
    $value = $this->clean_value();
    $this->query->add_filter("op_starts.{$this->field}", create_function('$item', "return preg_match('/^{$value}/', \$item->{$this->field});"));
  }

  /**
   * Helper method to cleanup a value for use in a regular expression.
   *
   * @return string
   */
  function clean_value() {
    return  preg_quote($this->value);
  }

}
