<?php

/**
 * @file
 * Contains ArchibaldVcardEntityGenerator.
 */

class ArchibaldVcardEntityGenerator extends DevelContribGeneratorDefault {

  /**
   * @{inheritdoc}
   */
  protected function createEntity() {
    $entity = parent::createEntity();

    // The first name, last name, and company name, should not be too long,
    // otherwise we might run into issues when editing a generated VCard.
    // Because the label is generated by setting concatenating these fields,
    // the label length will exceed 255 characters, and the form submission will
    // create a PDO error. Re-generate them.
    $first_name   = devel_create_greeking(1, TRUE);
    $last_name    = devel_create_greeking(1, TRUE);
    $organization = devel_create_greeking(rand(1, 3), TRUE);

    // Set the label, as it would be if the VCard was created by hand.
    $label_property = $this->entityInfo['entity keys']['label'];
    $entity->{$label_property} = "$last_name $first_name ($organization)";

    // Update the fields.
    $entity->vcard_first_name[LANGUAGE_NONE][0]['value']   = $first_name;
    $entity->vcard_last_name[LANGUAGE_NONE][0]['value']    = $last_name;
    $entity->vcard_organization[LANGUAGE_NONE][0]['value'] = $organization;

    return $entity;
  }
}
