<?php

namespace Drupal\entity_reference_revisions;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\entity_reference_revisions\Normalizer\EntityReferenceRevisionItemNormalizer;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service Provider for Entity Reference Revisions.
 */
class EntityReferenceRevisionsServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $modules = $container->getParameter('container.modules');
    if (isset($modules['hal'])) {
      // Hal module is enabled, add our new normalizer for entity reference
      // revision items.

      // To avoid problems the arguments to
      // \Drupal\hal\Normalizer\EntityReferenceItemNormalizer change, re-use
      // the same constructor arguments and set the additional dependency
      // with a setter method.
      $parent_definition = $container->getDefinition('serializer.normalizer.entity_reference_item.hal');
      $service_definition = new Definition(EntityReferenceRevisionItemNormalizer::class, $parent_definition->getArguments());
      $service_definition->addMethodCall('setEntityTypeManager', [new Reference('entity_type.manager')]);

      // The priority must be higher than that of
      // serializer.normalizer.entity_reference_item.hal in
      // hal.services.yml.
      $service_definition->addTag('normalizer', array('priority' => $parent_definition->getTags()['normalizer'][0]['priority'] + 1));
      $container->setDefinition('serializer.normalizer.entity_reference_revision_item', $service_definition);
    }
  }

}
