<?php
/**
 * @file
 * Enables modules and site configuration for a standard site installation.
 */

use Drupal\Core\Form\FormStateInterface;

/**
 * Implements hook_form_alter().
 *
 * Creates additional install settings.
 */
function architecture_corporate_profile_form_alter(&$form, FormStateInterface &$form_state, $form_id) {
  if ($form_id == 'install_configure_form') {
    // Add new option at configure site form. If checkbox was selected, we
    // enable custom module, which sends usage statistics.
    $form['additional_settings'] = array(
      '#type' => 'fieldset',
      '#title' => t('Additional settings'),
      '#collapsible' => FALSE,
    );
    $form['additional_settings']['send_message'] = array(
      '#type' => 'checkbox',
      '#title' => t('Send info to developers team'),
      '#description' => t('You can send us the anonymous data about your site (URL and site-name). If you have any problems it can help us fix them.'),
      '#default_value' => TRUE,
    );
    $form['#submit'][] = 'architecture_corporate_profile_install_configure_form_custom_submit';
  }
}

/**
 * Submit callback.
 *
 * @see system_form_install_configure_form_alter()
 */
function architecture_corporate_profile_install_configure_form_custom_submit($form, FormStateInterface &$form_state) {
  if ($form_state->getValue('send_message')) {
    \Drupal::service('module_installer')->install(['profile_stat_sender']);
  }
}