(function($) {
    Drupal.behaviors.area_print = {
        attach: function(context, settings) {
            var css_selector = settings.area_print.selector;
            buttonId = settings.area_print.button_id;
            $('#'+buttonId).click(function(event) {
                event.preventDefault();
                if (navigator.appName == 'Microsoft Internet Explorer') {
                    areaPrintIE(css_selector);
                }
                else {
                    areaPrint(css_selector);
                }
                event.stopPropagation();
            });

            function areaPrint(css_selector) {
                var newWin = window.open('' + self.location);
                newWin.onload = function() {
                    // Hide everything except the printed area
                    $(css_selector, newWin.document).show().parentsUntil('').addBack().siblings().hide();
                    // Print and close
                    newWin.print();
                    newWin.close();
                }
            }

            function areaPrintIE(css_selector) {
                var newWin = window.open('' + self.location);
                newWin.document.onload = new
                function() {
                    // IE does not actually wait for the page to load, so we need to add pause to the user experience.
                    newWin.alert('Press OK to print.');
                    // Hide everything except the printed area
                    $(css_selector, newWin.document).show().parentsUntil('').andSelf().siblings().hide();
                    // Print and close
                    newWin.print();
                    newWin.close();
                }
            }
        }
    };
})(jQuery);
