<?php

namespace Drupal\area_print\Element;
use Drupal\Core\Render\Element\RenderElement;
use Drupal\Core\Render\Element\Button;
use Drupal\Core\Render\Markup;

/**
 * Render element for a button (or link) to print a defined area.
 *
 * @RenderElement("print_area_button")
 *
 * Usage Example:
 * @code
 * $renderable['my_button'] = [
 *   '#type' => 'print_area_button',
 *   '#value' => t('Print page'),
 *   '#selector' => 'main#main',
 *   '#as_link' => FALSE,
 * );
 * @endcode
 */
class PrintButton extends RenderElement {

  /**
   * {@inheritDoc}
   */
  public function getInfo() {
    return [
      '#css_selector' => 'main#main',
      '#as_link' => FALSE,
      '#label' => t('Print'),
      '#pre_render' => [[get_class(), 'preRender']]
    ];
  }


  public static function preRender($element) {
    $id = 'print-area-button';// assumes there's only one per page
    $title = t("Opens in a popup");

    // this isn't quite how it should be done.
    if ($element['#as_link']) {
      $text = '<a id = "'.$id.'" title = "'.$title.'">'.$element['#label'].'</a>';
    }
    else {
      $text = '<button id = "'.$id.'" title= "'.$title.'">'.$element['#label'].'</button>';
    }
    $element += [
      '#type' => '#markup',
      '#markup' => Markup::create($text),
      '#attached' => [
        'library' =>['area_print/area_print_js'],
        'drupalSettings' => [
          'area_print' => [
            'button_id'  => $id,
            'selector'  => $element['#css_selector'],
          ]
        ]
      ]
    ];
    return $element;
  }

}
