<?php
/**
 * Created by PhpStorm.
 * User: jfeltkamp
 * Date: 25.09.17
 * Time: 16:15
 */
namespace Drupal\arguments\Events;

final class ArgumentsEvent {

  /**
   * @var integer
   *   Stored value for pro argument.
   */
  const ARG_PRO = 1;

  /**
   * @var integer
   *   Stored value for con argument.
   */
  const ARG_CON = 2;

  /**
   * @var integer
   *   The default value for argument type.
   */
  const ARG_DEFAULT = self::ARG_PRO;

  /**
   * Check if voting API has votes or not.
   *
   * @param $aid integer
   *   Argument id to check.
   * @return bool
   *   If evaluation has begun or not.
   */
  public static function hasEvaluationBegun($aid) {
    unset($aid);
    // @todo insert check for voting API.
    return FALSE;
  }
}
