<?php

namespace Drupal\arrival_message\Form;

// Classes referenced in this class:
use Drupal\Core\Form\FormStateInterface;

// This is the form we are extending.
use Drupal\system\Form\SiteInformationForm;

/**
 * Configure site information settings for this site.
 */
class ArrivalMessageSiteSettingForm extends SiteInformationForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $site_config = $this->config('system.site');
    $form = parent::buildForm($form, $form_state);
    $form['site_information']['arrival_message'] = [
      '#type' => 'textarea',
      '#title' => t('Arrival Message'),
      '#default_value' => $site_config->get('message'),
      '#description' => $this->t('The description of the message'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('system.site')
      ->set('message', $form_state->getValue('arrival_message'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
