<?php // -*-php-*-

function article_pathauto($op) {
  switch ($op) {
  case 'settings':
    $settings = array();
    $settings['module'] = 'article';
    $settings['token_type'] = 'taxonomy';
    $settings['groupheader'] = t('Article path settings');
    $settings['patterndescr'] = t('Patterns for Article module');
    $settings['patterndefault'] = t('article/[cat-raw]');
    return (object) $settings;
  default:
    break;
  }
}

/**
 * Implementation of hook_taxonomy()
 */
function article_taxonomy($op, $type, $array = NULL) {
  if ($type != 'term') {
    return;
  }

  $vocab = variable_get('article_vocab', '');
  if (!is_array($vocab)) {
    return;
  }

  if (!in_array($array['vid'], array_values($vocab))) {
    return;
  }

  switch ($op) {
  case 'insert':
  case 'update':
    _pathauto_include();
    $placeholders = pathauto_get_placeholders('taxonomy', (object)$array);
    $placeholders;
    pathauto_create_alias('article', $op, $placeholders, 'article/'.$array['tid']);
  default:
    break;
  }
}
?>
