<?php

/**
 * @file
 * Theme and preprocess functions for forms.
 */

/**
 * Implements hook_form_user_login_form_alter().
 */
function artisan_form_user_login_form_alter(&$form) {
  $form['name']['#attributes']['placeholder'] = $form['name']['#title'];
  $form['pass']['#attributes']['placeholder'] = $form['pass']['#title'];
}

/**
 * Implements hook_form_user_pass_alter().
 */
function artisan_form_user_pass_alter(&$form) {
  $form['name']['#attributes']['placeholder'] = $form['name']['#title'];
}

/**
 * Implements hook_theme_suggestions_HOOK_alter().
 */
function artisan_theme_suggestions_form_element_alter(array &$suggestions, array &$variables) {
  $element = $variables['element'];
  if (isset($element['#type'])) {
    $suggestions[] = $variables['theme_hook_original'] . '__' . $element['#type'];
  }
}

/**
 * Implements hook_preprocess_page__user__login().
 */
function artisan_preprocess_form_element(&$variables) {
  $variables['floating_label'] = theme_get_setting('form_element_floating_label') ?? FALSE;
  $variables['switches'] = theme_get_setting('form_element_switches') ?? FALSE;
  $variables['inline'] = theme_get_setting('form_element_inline') ?? FALSE;
}
