<?php

namespace Drupal\artisan\customizations;

/**
 * Page footer top links - Artisan customizations definition.
 */
trait ArtisanCustomizationsFooterTopLinksTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getFooterTopLinksDefinitions() {
    return [
      'footer_top_links' => [
        'wrapper' => 'footer',
        'label' => t('Footer Top Links'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'decoration' => [
            'label' => t('Decoration'),
            'description' => ArtisanCustomizations::DECORATION_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'accent_color' => [
            'label' => t('Accent color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
