<?php

namespace Drupal\artisan\customizations;

/**
 * Page header - Artisan customizations definition.
 */
trait ArtisanCustomizationsHeaderTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getHeaderDefinitions() {
    return [
      'header' => [
        'wrapper' => 'header',
        'label' => t('Global'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'static' => [
            'label' => t('Static (default sticky)'),
            'type' => 'checkbox',
          ],
          'opacity' => [
            'label' => t('Opacity'),
            'description' => ArtisanCustomizations::OPACITY_EXAMPLE,
          ],
          'height' => [
            'label' => t('Height'),
            'description' => ArtisanCustomizations::HEIGHT_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'background' => [
            'label' => t('Background'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
