<?php

namespace Drupal\artisan\customizations;

/**
 * Artisan custmizations interface.
 */
interface ArtisanCustomizationsInterface {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  public static function getDefinitions();

  /**
   * Theme settings form elements.
   *
   * @return array
   *   Theme settings form elements.
   */
  public static function getThemeSettingsFormElements();

  /**
   * Page attachement styles (css variables generated by definitions & values).
   *
   * Use "$settings['artisan_customizations_verbose'] = TRUE;" to see verbose
   * complete list & formatted, do not use in pro environments.
   *
   * @return array
   *   Style tag data-artisan-customizations with ready to use css variables.
   */
  public static function getAttachmentStyles();

  /**
   * Page attachement styles preview (css variables).
   *
   * @return array
   *   Pre tag with preview of css variables.
   */
  public static function getAttachmentStylesPreview();

}
