<?php

/**
 * @file
 * Funtions to alter customizations.
 */

use Drupal\artisan\customizations\ArtisanCustomizations;

/**
 * Implements hook_artisan_customizations_alter().
 */
function artisan_starterkit_artisan_customizations_alter(&$customizations) {
  // Use just primary & secondary with outline & link, discard others.
  // @see ArtisanCustomizations::getDefinitions().
  // @see ArtisanCustomizationsBtnVariantsTrait::getBtnVariantsList().
  $buttons_to_remove = [
    'btn_success',
    'btn_outline_success',
    'btn_danger',
    'btn_outline_danger',
    'btn_warning',
    'btn_outline_warning',
    'btn_info',
    'btn_outline_info',
    'btn_light',
    'btn_outline_light',
    'btn_dark',
    'btn_outline_dark',
  ];
  foreach ($buttons_to_remove as $delta) {
    if (!empty($customizations[$delta])) {
      unset($customizations[$delta]);
    }
  }
  // Add example component definition.
  $customizations['example'] = [
    'wrapper' => 'component',
    'label' => t('Example'),
    'description' => t('See hook_artisan_customizations_alter() & artisan_starterkit_artisan_customizations_alter(). These customizations will be available as css variables under "div[data-component-id="artisan_starterkit:example"]" selector. E.g: "div[data-component-id="artisan_starterkit:example"] { color: var(--theme-example-color); }.'),
    'type_default' => 'textfield',
    'selector_default' => 'div[data-component-id="artisan_starterkit:example"]',
    'list' => [
      'size' => [
        'label' => t('Font size'),
        'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
      ],
      'color' => [
        'label' => t('Color'),
        'type' => 'color',
      ],
    ],
  ];
}
