<?php

namespace Drupal\artisan\customizations;

/**
 * Page header top links - Artisan customizations definition.
 */
trait ArtisanCustomizationsHeaderTopLinksTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getHeaderTopLinksDefinitions() {
    return [
      'header_top_links' => [
        'wrapper' => 'header',
        'label' => t('Header Top Links'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'decoration' => [
            'label' => t('Decoration'),
            'description' => ArtisanCustomizations::DECORATION_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'accent_color' => [
            'label' => t('Accent color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
