<?php

namespace Drupal\artisan\customizations;

/**
 * Headings - Artisan customizations definition.
 */
trait ArtisanCustomizationsHeadingsTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getHeadingsDefinitions() {
    return [
      'headings' => [
        'wrapper' => 'headings',
        'label' => t('Global'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'decoration' => [
            'label' => t('Decoration'),
            'description' => ArtisanCustomizations::DECORATION_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
