<?php

namespace Drupal\artisan\customizations;

/**
 * Base font - Artisan customizations definition.
 */
trait ArtisanCustomizationsBaseFontTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getBaseFontDefinitions() {
    return [
      'base_font' => [
        'wrapper' => 'base',
        'label' => t('Base font'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'line_height' => [
            'label' => t('Line height'),
            'description' => ArtisanCustomizations::LINE_HEIGHT_EXAMPLE,
          ],
        ],
      ],
    ];
  }

}
