<?php

namespace Drupal\artisan\customizations;

/**
 * Breadcrumb - Artisan customizations definition.
 */
trait ArtisanCustomizationsBreadcrumbTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getBreadcrumbDefinitions() {
    return [
      'breadcrumb' => [
        'wrapper' => 'breadcrumb',
        'label' => t('Global'),
        'type_default' => 'textfield',
        'selector_default' => '.breadcrumb',
        'list' => [
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'padding_x' => [
            'label' => t('Horizontal inner spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'padding_y' => [
            'label' => t('Vertical inner spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'margin_y' => [
            'label' => t('Vertical outer spacing'),
            'description' => ArtisanCustomizations::MARGIN_EXAMPLE,
          ],
          'divider' => [
            'label' => t('Divider'),
            'description' => '"/", ">"',
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'background' => [
            'label' => t('Background'),
            'type' => 'color',
          ],
          'accent_color' => [
            'label' => t('Accent color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
