<?php

namespace Drupal\artisan\customizations;

/**
 * Buttons - Artisan customizations definition.
 */
trait ArtisanCustomizationsBtnTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getBtnDefinitions() {
    return [
      'btn' => [
        'wrapper' => 'buttons',
        'label' => t('Global'),
        'type_default' => 'textfield',
        'selector_default' => '.btn',
        'list' => [
          'border_width' => [
            'label' => t('Border width'),
            'description' => ArtisanCustomizations::BORDER_WIDTH_EXAMPLE,
          ],
          'border_radius' => [
            'label' => t('Border radius'),
            'description' => ArtisanCustomizations::BORDER_RADIUS_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'padding_x' => [
            'label' => t('Horizontal spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'padding_y' => [
            'label' => t('Vertical spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'line_height' => [
            'label' => t('Line height'),
            'description' => ArtisanCustomizations::LINE_HEIGHT_EXAMPLE,
          ],
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'disabled_opacity' => [
            'label' => t('Disabled opacity'),
            'type' => 'textfield',
            'description' => ArtisanCustomizations::OPACITY_EXAMPLE,
          ],
          'shadow' => [
            'label' => t('Box shadow'),
            'description' => ArtisanCustomizations::BOX_SHADOW_EXAMPLE,
          ],
        ],
      ],
    ];
  }

}
