<?php

namespace Drupal\artisan\customizations;

/**
 * Page footer - Artisan customizations definition.
 */
trait ArtisanCustomizationsFooterLinksTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getFooterLinksDefinitions() {
    return [
      'footer_links' => [
        'wrapper' => 'footer',
        'label' => t('Footer Links'),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'decoration' => [
            'label' => t('Decoration'),
            'description' => ArtisanCustomizations::DECORATION_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'accent_color' => [
            'label' => t('Accent color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

}
