<?php

namespace Drupal\artisan\customizations;

/**
 * Forms - Artisan customizations definition.
 */
trait ArtisanCustomizationsFormTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getFormDefinitions() {
    $definitions = [
      'form' => [
        'wrapper' => 'form',
        'label' => t('Global'),
        'wrapper_description' => t('Textfield, email, number, textarea, checkbox, radio.'),
        'type_default' => 'textfield',
        'selector_default' => 'form',
        'list' => [
          'element_margin_bottom' => [
            'label' => t('Form element bottom spacing'),
            'description' => ArtisanCustomizations::MARGIN_EXAMPLE,
          ],
          'element_floating_label' => [
            'label' => t('Set floating labels (checkboxes, radios, files & textareas excluded)'),
            'type' => 'checkbox',
          ],
          'element_switches' => [
            'label' => t('Use switches (checkboxes and radios only)'),
            'type' => 'checkbox',
          ],
          'element_inline' => [
            'label' => t('Inline when multiple (checkboxes and radios only)'),
            'type' => 'checkbox',
          ],
        ],
      ],
    ];
    $definitions += static::getFormInputDefinitions();
    $definitions += static::getFormLabelDefinitions();
    return $definitions;
  }

  /**
   * Form input definitions.
   *
   * @return array
   *   Definitions.
   */
  protected static function getFormInputDefinitions() {
    return [
      'form_input' => [
        'wrapper' => 'form',
        'label' => t('Input'),
        'wrapper_description' => t('Textfield, email, number, textarea, checkbox, radio.'),
        'type_default' => 'textfield',
        'selector_default' => 'form',
        'list' => [
          'border_width' => [
            'label' => t('Border width'),
            'description' => ArtisanCustomizations::BORDER_WIDTH_EXAMPLE,
          ],
          'border_radius' => [
            'label' => t('Border radius'),
            'description' => ArtisanCustomizations::BORDER_RADIUS_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'padding_x' => [
            'label' => t('Horizontal spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'padding_y' => [
            'label' => t('Vertical spacing'),
            'description' => ArtisanCustomizations::PADDING_EXAMPLE,
          ],
          'line_height' => [
            'label' => t('Line height'),
            'description' => ArtisanCustomizations::LINE_HEIGHT_EXAMPLE,
          ],
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'shadow' => [
            'label' => t('Box shadow'),
            'description' => ArtisanCustomizations::BOX_SHADOW_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
          'placeholder_color' => [
            'label' => t('Placeholder color'),
            'type' => 'color',
          ],
          'background' => [
            'label' => t('Background'),
            'type' => 'color',
          ],
          'border_color' => [
            'label' => t('Border color'),
            'type' => 'color',
          ],
          'disabled_background' => [
            'label' => t('Disabled background'),
            'type' => 'color',
          ],
          'accent_color' => [
            'label' => t('Accent color'),
            'type' => 'color',
          ],
          'accent_background' => [
            'label' => t('Accent background'),
            'type' => 'color',
          ],
          'accent_border_color' => [
            'label' => t('Accent border color'),
            'type' => 'color',
          ],
        ],
      ],
    ];
  }

  /**
   * Form label definitions.
   *
   * @return array
   *   Definitions.
   */
  protected static function getFormLabelDefinitions() {
    return [
      'form_label' => [
        'wrapper' => 'form',
        'label' => t('Label'),
        'wrapper_description' => t('Textfield, email, number, textarea, checkbox, radio.'),
        'type_default' => 'textfield',
        'selector_default' => 'form',
        'list' => [
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_size' => [
            'label' => t('Font size'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'line_height' => [
            'label' => t('Line height'),
            'description' => ArtisanCustomizations::LINE_HEIGHT_EXAMPLE,
          ],
          'margin_bottom' => [
            'label' => t('Bottom spacing'),
            'description' => ArtisanCustomizations::MARGIN_EXAMPLE,
          ],
        ],
      ],
    ];
  }

}
