<?php

namespace Drupal\artisan\customizations;

/**
 * Heading variants - Artisan customizations definition.
 */
trait ArtisanCustomizationsHxTrait {

  /**
   * Variants list to generate definition/s.
   */
  const HX_LIST = [1, 2, 3, 4, 5, 6];

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getHxDefinitions() {
    $definitions = [];
    foreach (static::HX_LIST as $heading_number) {
      $definitions['h' . $heading_number] = [
        'wrapper' => 'headings',
        'label' => t('Heading :number', [
          ':number' => $heading_number,
        ]),
        'type_default' => 'textfield',
        'selector_default' => ':root',
        'list' => [
          'font_size' => [
            'label' => t('Font size (Small/Medium Screens)'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_size_lg' => [
            'label' => t('Font size (Large Screens)'),
            'description' => ArtisanCustomizations::FONT_SIZE_EXAMPLE,
          ],
          'font_family' => [
            'label' => t('Font family'),
            'description' => ArtisanCustomizations::FONT_FAMILY_EXAMPLE,
          ],
          'font_weight' => [
            'label' => t('Font weight'),
            'description' => ArtisanCustomizations::FONT_WEIGHT_EXAMPLE,
          ],
          'decoration' => [
            'label' => t('Decoration'),
            'description' => ArtisanCustomizations::DECORATION_EXAMPLE,
          ],
          'color' => [
            'label' => t('Color'),
            'type' => 'color',
          ],
        ],
      ];
    }
    return $definitions;
  }

}
