<?php

namespace Drupal\artisan\customizations;

/**
 * Color palette - Artisan customizations definition.
 */
trait ArtisanCustomizationsPaletteTrait {

  /**
   * Main definition/s.
   *
   * @return array
   *   Definition.
   */
  protected static function getPaletteDefinitions() {
    return [
      'palette' => [
        'wrapper' => 'base',
        'label' => t('Palette'),
        'type_default' => 'color',
        'selector_default' => ':root',
        'list' => [
          'branding_primary' => ['label' => t('Branding primary')],
          'branding_secondary' => ['label' => t('Branding secondary')],
          'primary' => ['label' => t('Primary')],
          'secondary' => ['label' => t('Secondary')],
          'success' => ['label' => t('Success')],
          'info' => ['label' => t('Info')],
          'warning' => ['label' => t('Warning')],
          'danger' => ['label' => t('Danger')],
          'light' => ['label' => t('Light')],
          'dark' => ['label' => t('Dark')],
          'white' => ['label' => t('White')],
          'black' => ['label' => t('Black')],
        ],
      ],
    ];
  }

}
