// Importar Swiper y módulos necesarios
import { Swiper } from 'swiper';
import { Navigation, Pagination, Scrollbar, Autoplay, Grid, FreeMode } from 'swiper/modules';

((Drupal, once) => {
  Drupal.behaviors.swiper = {
    attach: (context) => {
      once('swiper', '.swiper:not(.thumbs-slider)', context).forEach((container) => {
        const options = JSON.parse(container.getAttribute('data-swiper-options') || '{}');
        options.modules = [Navigation, Pagination, Scrollbar, Autoplay, Grid, FreeMode];
        let slider = new Swiper(container, options);
      });
    },
  };
})(Drupal, once);
