
## Installation & Setup

### npm and node minimal versions
- npm >=6.14
- node >=12.14

### Install the theme
Just as you would normally install a contributed Drupal module or theme via Composer.
```bash
composer require drupal/artisan
```

### Drush command to generate a new theme (generation, compiling, install & set default)
```twig
drush --include="web/themes/contrib/artisan" artisan
```

*Optional "name" param can be passed, used with "-y" it will make everything without asking anything.
```twig
drush --include="web/themes/contrib/artisan" artisan "Artisan Mysite" -y
```


### To update build
```twig
npm run build
```
```twig
npm run build:watch
```

### Vite dev mode

When using ddev expose port ".ddev/config.yaml":
```yaml
web_extra_exposed_ports:
- name: nodejs
  container_port: 3000
  http_port: 3001
  https_port: 3000
```

Restart ddev after having port accesible 3000
```bash
ddev restart
```

Execute npm dev task from your theme
```bash
cd web/themes/custom/[ARTISAN_SUBTHEME_FROM_STARTERKIT]
npm run dev
```

Clear cache
```
ddev drush cr
```

Thats it! Note build source files should be used in components libraries definitions (more info into components section), then by Artisan will handle automatically dist or dev resources from library definition & vite manifest.

Now css/js from vite dev will be used directly along with vite client to have live preview without reloading page in browser. You can check that resources now loads from "external" url "https://[SITE].ddev.site:3000/themes/custom/[ARTISAN_SUBTHEME_FROM_STARTERKIT]/dist"

#### Different vite dev url & port
If dev mode is not automatically active after previous steps or maybe you want to specify different url or port.
Then go to your theme settings (e.g: /admin/appearance/settings/artisan_starterkit) & adjust "Vite: Dev host" & "Vite: Dev port", also ensure you specify same route & port into your theme "vite.config.js" file "serverPort = 3000;" & "serverOriginHost = 'https://my-drupal-site.ddev.site';".

NOTE: Wrong setup may result into not loaded styles.


## Artisan CSS / JS compilation

Artisan uses Vite as its build tool and assets bundler.

### How to compile SDCs CSS/JS?

Inside your component directory, create and src folder and place your CSS/JS file inside it.

```
components/
└── my-component/
    └── src/
        └── my-component.css
```

## SDC

### Styling SDC
We encourage developers to style your SDCs using CSS Variables.
```css
[data-component-id="my-component"] {
  --my-component-body-font-size: var(--theme-font-size-base);
  --my-component-image-border-radius: var(--theme-radius);
  --my-component-background-color: var(--theme-primary);

  background-color: var(--my-component-background-color);

  .my-component-image {
    border-radius: var(--my-component-image-border-radius);
  }

  .my-component-body {
    font-size: var(--my-component-body-font-size);
  }
}
```

## Helpful

### Sticky / fixed top auto calculated
In order to place an element like a search sidebar positioned sticky or fixed
you will be able to use "--theme-sticky-fixed-offset-top" CSS variable.
So top position is auto calculated & refreshed taking into account possible
sticky header & admin menu toolbar.

## Authors
- [Cristian Aliaga](https://www.drupal.org/u/crzdev)
- [Alejandro Cabarcos](https://www.drupal.org/u/alejandro-cabarcos)
- [Fran Rouco](https://www.drupal.org/u/frouco)
- [Alberto Antoranz](https://www.drupal.org/u/alzz)
